<?php

/**
 * Generate OAuth installation URL
 */
function generateInstallUrl($shop, $host = '')
{
    $scopes = SHOPIFY_SCOPES;
    $redirectUri = APP_CALLBACK_URL;
    $state = bin2hex(random_bytes(16));

    $_SESSION['oauth_state'] = $state;
    $_SESSION['install_shop'] = $shop;
    if ($host) {
        $_SESSION['install_host'] = $host;
    }

    $params = [
        'client_id' => SHOPIFY_API_KEY,
        'scope' => $scopes,
        'redirect_uri' => $redirectUri,
        'state' => $state
    ];

    if ($host) {
        $params['grant_options[]'] = 'per-user';
    }

    return "https://{$shop}/admin/oauth/authorize?" . http_build_query($params);
}

/**
 * Exchange authorization code for access token
 */
function exchangeCodeForAccessToken($shop, $code)
{
    logMessage("Exchanging code for access token", 'INFO', $shop);

    $url = "https://{$shop}/admin/oauth/access_token";

    $postData = [
        'client_id' => SHOPIFY_API_KEY,
        'client_secret' => SHOPIFY_API_SECRET,
        'code' => $code
    ];

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($postData),
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'Accept: application/json'
        ],
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_TIMEOUT => 30
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);

    if ($curlError) {
        logMessage("cURL error during token exchange: $curlError", 'ERROR', $shop);
        return false;
    }

    logMessage("Token exchange response: HTTP $httpCode", 'DEBUG', $shop);

    if ($httpCode === 200) {
        $data = json_decode($response, true);
        $accessToken = $data['access_token'] ?? null;

        if ($accessToken) {
            logMessage("Successfully obtained access token for shop: $shop", 'INFO');
        } else {
            logMessage("No access token in response for shop: $shop", 'ERROR');
        }

        return $accessToken;
    }

    logMessage("Token exchange failed with HTTP $httpCode: $response", 'ERROR', $shop);
    return false;
}
