<?php

session_start();
require_once __DIR__ . '/config/config.php';

$shop = $_GET['shop'] ?? '';

if (!$shop) {
    die('Shop parameter is required');
}

$shop = cleanShopDomain($shop);

// Verify HMAC if present (for embedded apps)
if (isset($_GET['hmac'])) {
    if (!verifyHmac($_GET)) {
        die('Invalid HMAC signature. This request may not be from Shopify.');
    }
}

// Generate installation URL and redirect
$installUrl = generateInstallUrl($shop);
logMessage("Redirecting to installation URL for shop: $shop", 'INFO');
header("Location: " . $installUrl);
exit;
