<?php

session_start();

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/tridentity-api.php';

logMessage("=== AUTH.PH ACCESSED ===");
logMessage("GET parameters: " . json_encode($_GET));

$shop = $_GET['shop'] ?? '';
$action = $_GET['action'] ?? '';

if (!$shop) {
    die('Shop parameter is required.');
}

$shop = cleanShopDomain($shop);
if (!verifyShopDomain($shop)) {
    die('Invalid Shopify store domain.');
}

if ($action === 'login') {
    logMessage("Initiating Tridentity login for shop: " . $shop, 'INFO', $shop);

    // Check if app is installed
    if (!TokenStorage::isInstalled($shop)) {
        logMessage("App not installed for shop: " . $shop, 'ERROR', $shop);
        echo "App not installed. Please install the app first from Shopify Admin.";
        exit;
    }

    // Generate Tridentity login URL
    $loginUrl = generateTridentityLoginUrl($shop);
    
    logMessage("Redirecting to Tridentity: " . $loginUrl, 'INFO', $shop);
    header("Location: " . $loginUrl);
    exit;
    
} else {
    
    echo "Invalid action.";
    exit;
}