<?php

/**
 * Verify Tridentity authentication token
 */
function verifyTridentityToken($authToken)
{
    $url = TRIDENTITY_API_URL . '/external/auth/token/verify';

    logMessage("Tridentity Token Verification - URL: $url", 'DEBUG');
    logMessage("Tridentity Token Verification - Auth Token: " . substr($authToken, 0, 10) . "...", 'DEBUG');

    $postData = json_encode(['authToken' => $authToken]);

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $postData,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'api-key: ' . TRIDENTITY_API_KEY,
            'app-id: ' . TRIDENTITY_APP_ID
        ],
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_TIMEOUT => 30
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);
    logMessage("Tridentity token verification response: HTTP $httpCode - $response", 'INFO');

    if ($curlError) {
        logMessage("Tridentity token verification CURL error: $curlError", 'ERROR');
    }

    if ($httpCode === 200 || $httpCode === 201) {
        $data = json_decode($response, true);
        return $data['data']['user']['identityToken'] ?? false;
    }

    return false;
}

/**
 * Get user profile from Tridentity
 */
function getTridentityUserProfile($identityToken)
{
    $url = TRIDENTITY_API_URL . '/external/user/profile';

    logMessage("Tridentity Profile Fetch - URL: $url", 'DEBUG');
    logMessage("Tridentity Profile Fetch - Identity Token: " . substr($identityToken, 0, 10) . "...", 'DEBUG');

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            'app-id: ' . TRIDENTITY_APP_ID,
            'api-key: ' . TRIDENTITY_API_KEY,
            'identity-token: ' . $identityToken,
            'Content-Type: application/json'
        ],
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_TIMEOUT => 30
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);

    logMessage("Tridentity profile fetch response: HTTP $httpCode", 'INFO');

    if ($curlError) {
        logMessage("Tridentity profile fetch CURL error: $curlError", 'ERROR');
    }

    if ($httpCode === 200) {
        return json_decode($response, true);
    }

    logMessage("Tridentity profile fetch failed with HTTP $httpCode: $response", 'ERROR');
    return false;
}

/**
 * Generate Tridentity login URL
 */
function generateTridentityLoginUrl($shop)
{
    $callbackUrl = APP_CALLBACK_URL . '?shop=' . urlencode($shop);
    $loginUrl = TRIDENTITY_OUTER_URL . '/oauth/login?app_id=' . TRIDENTITY_APP_ID . '&redirect=' . urlencode($callbackUrl);

    logMessage("Generated Tridentity login URL: $loginUrl", 'DEBUG');

    return $loginUrl;
}
