<?php

// Manual token setup
require_once __DIR__ . '/config/config.php';

$shop = 'dy8060-np.myshopify.com';
$accessToken = 'shpat_your_access_token_here'; // Get this from Shopify Admin

if ($_POST['token']) {
    $accessToken = $_POST['token'];
    $shop = $_POST['shop'];
    
    if (TokenStorage::storeAccessToken($shop, $accessToken)) {
        echo "<div style='color: green;'>Access token stored successfully!</div>";
    } else {
        echo "<div style='color: red;'>Failed to store access token.</div>";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Setup Access Token</title>
</head>
<body>
    <h1>Setup Shopify Access Token</h1>
    <p>Get your access token from Shopify Admin → Apps → Your App</p>
    
    <form method="POST">
        <div>
            <label>Shop Domain:</label>
            <input type="text" name="shop" value="<?= htmlspecialchars($shop) ?>" required>
        </div>
        <div>
            <label>Access Token:</label>
            <input type="text" name="token" value="<?= htmlspecialchars($accessToken) ?>" required style="width: 400px;">
        </div>
        <button type="submit">Save Token</button>
    </form>
    
    <hr>
    
    <h2>Test Links:</h2>
    <ul>
        <li><a href="test.php">Test Page</a></li>
        <li><a href="auth.php?shop=<?= $shop ?>&action=login">Test Tridentity Login</a></li>
        <li><a href="index.php?shop=<?= $shop ?>">Main App</a></li>
    </ul>
</body>
</html>
